*The included code reproduces results that appear in the Introduction section of paper: "Factor Endowments, Economic Integration, Sanctions, and Offshores: Evidence from Inward FDI in Russia. Comparative Economic Studies (2022)." doi: 10.1057/s41294-022-00202-6
*Author information (ORCID IDs):
*Andrzej Cieślik: 0000-0002-7834-7384
*Oleg Gurshev: 0000-0003-4532-7819

*------------------------------------------------------------------------
* UNILATERAL SAMPLE RESULTS
*panel data setup*
encode (host), gen(host1)
encode (country), gen(country1)
egen countrypair=group(country1 host1)
xtset countrypair year

*generation of variables
gen GDP_DIFF = ln(gdp_diff)
gen K_DIFF = ln(k_diff)
gen HC_DIFF = ln(h_diff)
gen GDP_SUM =ln(gdp_sum)
gen DIST = ln(dist)
encode(fta), gen (FTA)

*fixed effects
quietly tabulate year, gen (dyear)

*summary and correlation tables
global ylist y
global xlist GDP_DIFF K_DIFF HC_DIFF GDP_SUM DIST tf tc_rus ic_rus sanct offshore cu LAG_CU LAG_LAG_CU fta LAG_FTA LAG_LAG_FTA
asdoc sum $ylist $xlist
global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM LAG_TF_HOME LAG_SANCT


asdoc sum $ylist $xlist
asdoc correl $ylist $xlist


esttab, se star(+ 0.10 ** 0.05 *** 0.01)

*------------------------------------------------------------------------
*Estimation: 2008-2019
*LAG, TIME EFFECTS*
*Case 1: naive regressions
eststo clear

global ylist y
global xlist LAG_GDP_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME 
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)


global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME 
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)


global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME LAG_SANCT offshore
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)

esttab, se star(+ 0.10 ** 0.05 *** 0.01)

esttab using LAG_general_cluster1.rtf, se star(+ 0.10 ** 0.05 *** 0.01)
*------------------------------------------------------------------------
* Case 2: decomposed offshore stocks
eststo clear

global ylist y_5

global xlist LAG_GDP_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)

global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME 
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)

global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME LAG_SANCT LAG_OFFSHORE
eststo: ppmlhdfe $ylist $xlist , a(dyear*)  cluster(countrypair)

esttab using LAG_decomp_cluster.rtf, se star(+ 0.10 ** 0.05 *** 0.01)
*------------------------------------------------------------------------
* Case 3: removed offshore stocks
eststo clear

global ylist y

global xlist LAG_GDP_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME 
eststo: ppmlhdfe $ylist $xlist if offshore == 0, a(dyear*)  cluster(countrypair)

global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME 
eststo: ppmlhdfe $ylist $xlist if offshore == 0, a(dyear*)  cluster(countrypair)

global xlist LAG_GDP_DIFF LAG_K_DIFF LAG_HC_DIFF LAG_GDP_SUM DIST LAG_TF_HOME LAG_SANCT 
eststo: ppmlhdfe $ylist $xlist if offshore == 0, a(dyear*)  cluster(countrypair)

esttab using LAG_restricted_cluster.rtf, se star(+ 0.10 ** 0.05 *** 0.01)

*------------------------------------------------------------------------
